# PixWash

**PixWash** is a fast and intuitive Windows application for sorting and cleaning your photo and video collections. Review your files one by one and easily delete the ones you no longer need.

## 🚀 Features

- **Fast image and video sorting**: Browse your files one by one and decide instantly
- **Safe deletion**: Files are sent to the Recycle Bin (never permanently deleted)
- **Optimized preview**: Fast loading even for RAW and heavy files
- **Subfolder support**: Option to include subfolders in the scan
- **Session resume**: Continue where you left off thanks to tracking of already sorted files
- **EXIF data display**: View camera metadata on hover (Licensed version)
- **Wash Report**: Track your sorting statistics over time (Licensed version)

## 💎 Free vs Licensed Version

| Feature | Free | Licensed |
|---------|------|-----------|
| Sort images and videos | ✅ | ✅         |
| Safe deletion to Recycle Bin | ✅ | ✅         |
| Subfolder scanning | ✅ | ✅         |
| Session resume | ✅ | ✅         |
| **Media sorting limit** | 400 total | Unlimited |
| **Wash Report statistics** | ❌ | ✅         |
| **EXIF data display** | ❌ | ✅         |

To unlock the Pro version, purchase a license at [orogenmaker.lemonsqueezy.com](https://orogenmaker.lemonsqueezy.com) and activate it in the app by clicking the 🔑 icon.

## 📷 Supported Formats

### Images
| Standard | RAW (Cameras) | Professional |
|----------|---------------|--------------|
| JPG, JPEG | CR2, CR3 (Canon) | PSD, PSB (Photoshop) |
| PNG | NEF (Nikon) | XCF (GIMP) |
| GIF | ARW (Sony) | EXR, HDR |
| BMP | RW2 (Panasonic) | |
| WEBP | DNG (Adobe) | |
| TIFF | ORF (Olympus) | |
| ICO | RAF (Fujifilm) | |
| HEIC, HEIF | PEF (Pentax) | |
| SVG | SRW (Samsung) | |
| | X3F (Sigma) | |
| | 3FR (Hasselblad) | |
| | IIQ (Phase One) | |

### Videos
MP4, AVI, MKV, MOV, WMV, FLV, WEBM, M4V, MPG, MPEG, 3GP, TS, MTS, M2TS

## ⌨️ Keyboard Shortcuts

| Key | Action |
|-----|--------|
| `Enter` | Keep the file and move to next |
| `Delete` | Mark for deletion |
| `Backspace` | Go back to previous file |
| `Space` | Play/Pause (videos) |
| `←` / `→` | Skip backward/forward 5 seconds (videos) |
| `+` / `-` | Zoom in/out |
| `Esc` | Return to folder selection |

## 📖 How to Use

1. **Launch PixWash** and click **"Select a folder"** to choose a folder
2. **Enable "Include subfolders"** if you want to scan subfolders
3. **Sort your files**:
   - Press `Enter` to **keep** and move to next
   - Press `Delete` to **mark for deletion**
4. **Confirm**: Every 10 marked files, a grid displays the marked files (Wash Out)
   - Click **"Sweep"** to send to Recycle Bin
   - Click **"Keep"** to cancel the marking
5. **Finish**: At the end, choose to sort another folder or quit

## 💡 Tips

- RAW files are displayed via their embedded JPEG preview for ultra-fast loading
- The app automatically preloads upcoming files in the background
- You can go back at any time with `Backspace`
- Already sorted files are remembered: relaunch on the same folder to continue
- Click the ℹ️ icon next to file size to view EXIF data (Licensed version)

## ⚙️ System Requirements

- **System**: Windows 10 or later
- **Runtime**: .NET 9.0 or later

## 📜 Licenses and Attributions

PixWash uses the following open source libraries:

| Library | License | Description |
|---------|---------|-------------|
| [AvaloniaUI](https://avaloniaui.net/) | MIT | UI Framework |
| [CommunityToolkit.Mvvm](https://github.com/CommunityToolkit/dotnet) | MIT | MVVM Tools |
| [Magick.NET](https://github.com/dlemstra/Magick.NET) | Apache 2.0 | Image processing (ImageMagick) |
| [MetadataExtractor](https://github.com/drewnoakes/metadata-extractor-dotnet) | Apache 2.0 | Metadata extraction |
| [LibVLCSharp](https://github.com/videolan/libvlcsharp) | LGPL-2.1 | Video player |
| [VideoLAN LibVLC](https://www.videolan.org/vlc/libvlc.html) | LGPL-2.1 / GPL-2.0 | Multimedia playback engine |
| [Avalonia.Svg.Skia](https://github.com/wieslawsoltes/Svg.Skia) | MIT | SVG support |

## 📄 Copyright

© 2024-2026 OrogenMaker - All rights reserved.

PixWash is distributed as-is, without warranty of any kind.
